# Copyright 2017 Amazon.com, Inc. or its affiliates.

# This module is part of Amazon Linux Extras.
#
# Amazon Linux Extras is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License v2 as published
# by the Free Software Foundation.
#
# Amazon Linux Extras is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License
# along with Amazon Linux Extras.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import print_function, unicode_literals
import sys
import os
import logging as loggingmod
import gettext

from .cli import main as cli_main

gettext.textdomain("amazon_linux_extras")

argv = [a.decode("UTF-8", "replace") if hasattr(a, "decode") else a for a in sys.argv]

verbosity = [loggingmod.WARNING, loggingmod.INFO, loggingmod.DEBUG][min(argv.count("-v"), 2)]
loggingmod.basicConfig(level=verbosity, format="%(message)s")

if any(help in argv for help in "--help/-h/-?".split("/")):
    argv.insert(1, "help")

sys.exit(cli_main([arg for arg in argv[1:] if arg != "-v"]))

# vi: set expandtab autoindent shiftwidth=4 softtabstop=4 fileencoding=utf-8 filetype=python :
