===============================================================================
=     B i e n v e n i d o   a l   t u t o r   d e   V I M  -  Versión 1.4     =
===============================================================================

     Vim es un editor muy potente que dispone de muchos mandatos, demasiados
     para ser explicados en un tutor como éste. Este tutor está diseñado
     para describir suficientes mandatos para que usted sea capaz de
     aprender fácilmente a usar Vim como un editor de propósito general.

     El tiempo necesario para completar el tutor es aproximadamente de 25-30
     minutos, dependiendo de cuanto tiempo se dedique a la experimentación.

     Los mandatos de estas lecciones modificarán el texto. Haga una copia de
     este fichero para practicar (con «vimtutor» esto ya es una copia).

     Es importante recordar que este tutor está pensado para enseñar con
     la práctica. Esto significa que es necesario ejecutar los mandatos
     para aprenderlos adecuadamente. Si únicamente se lee el texto, se
     olvidarán los mandatos.

     Ahora, asegúrese de que la tecla de bloqueo de mayúsculas no está
     activada y pulse la tecla	j  lo suficiente para mover el cursor
     de forma que la Lección 1.1 ocupe completamente la pantalla.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		     Lección 1.1: MOVIMIENTOS DEL CURSOR

 ** Para mover el cursor, pulse las teclas h,j,k,l de la forma que se indica. **
      ^
      k       Indicación: La tecla h está a la izquierda y mueve a la izquierda.
 < h	 l >		  La tecla l está a la derecha y mueve a la derecha.
      j			  La tecla j parece una flecha que apunta hacia abajo.
      v

  1. Mueva el cursor por la pantalla hasta que se sienta cómodo con ello.

  2. Mantenga pulsada la tecla	j  hasta que se repita «automágicamente».
---> Ahora ya sabe como llegar a la lección siguiente.

  3. Utilizando la tecla abajo, vaya a la Lección 1.2.

Nota: Si alguna vez no está seguro sobre algo que ha tecleado, pulse <ESC>
      para situarse en modo Normal. Luego vuelva a teclear la orden que deseaba.

Nota: Las teclas de movimiento del cursor también funcionan. Pero usando
      hjkl podrá moverse mucho más rápido una vez que se acostumbre a ello.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		    Lección 1.2: ENTRANDO Y SALIENDO DE VIM

  ¡¡ NOTA: Antes de ejecutar alguno de los pasos siguientes lea primero
	   la lección entera!!

  1. Pulse la tecla <ESC> (para asegurarse de que está en modo Normal).

  2. Escriba:			:q! <INTRO>

---> Esto provoca la salida del editor SIN guardar ningún cambio que se haya
     hecho. Si quiere guardar los cambios y salir escriba:
				:wq <INTRO>

  3. Cuando vea el símbolo del sistema, escriba el mandato que le trajo a este
     tutor. Éste puede haber sido:   vimtutor <INTRO>
     Normalmente se usaría:	     vim tutor <INTRO>

---> 'vim' significa entrar al editor, 'tutor' es el fichero a editar.

  4. Si ha memorizado estos pasos y se se siente con confianza, ejecute los
     pasos 1 a 3 para salir y volver a entrar al editor. Después mueva el
     cursor hasta la Lección 1.3.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		   Lección 1.3: EDICIÓN DE TEXTO - BORRADO

** Estando en modo Normal pulse  x  para borrar el carácter sobre el cursor. **j


  1. Mueva el cursor a la línea de abajo señalada con --->.

  2. Para corregir los errores, mueva el cursor hasta que esté bajo el
     carácter que va a ser borrado.

  3. Pulse la tecla  x	para borrar el carácter sobrante.

  4. Repita los pasos 2 a 4 hasta que la frase sea la correcta.

---> La vvaca saltóó soobree laa luuuuna.

  5. Ahora que la línea esta correcta, continúe con la Lección 1.4.


NOTA: A medida que vaya avanzando en este tutor no intente memorizar,
      aprenda practicando.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		   Lección 1.4: EDICIÓN DE TEXTO - INSERCIÓN

      ** Estando en modo Normal pulse  i  para insertar texto. **


  1. Mueva el cursor a la primera línea de abajo señalada con --->.

  2. Para que la primera línea se igual a la segunda mueva el cursor bajo el
     primer carácter que sigue al texto que ha de ser insertado.

  3. Pulse  i  y escriba los caracteres a añadir.

  4. A medida que sea corregido cada error pulse <ESC> para volver al modo
     Normal. Repita los pasos 2 a 4 para corregir la frase.

---> Flta texto en esta .
---> Falta algo de texto en esta línea.

  5. Cuando se sienta cómodo insertando texto pase al resumen que esta más
     abajo.


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			    RESUMEN DE LA LECCIÓN 1


  1. El cursor se mueve utilizando las teclas de las flechas o las teclas hjkl.
	 h (izquierda)	   j (abajo)	  k (arriba)	  l (derecha)

  2. Para acceder a Vim (desde el símbolo del sistema %) escriba:
     vim FILENAME <INTRO>

  3. Para salir de Vim escriba: <ESC> :q! <INTRO> para eliminar todos
     los cambios.

  4. Para borrar un carácter sobre el cursor en modo Normal pulse:  x

  5. Para insertar texto en la posición del cursor estando en modo Normal:
	  pulse   i   escriba el texto	 pulse <ESC>

NOTA: Pulsando <ESC> se vuelve al modo Normal o cancela un mandato no deseado
      o incompleto.

Ahora continúe con la Lección 2.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		     Lección 2.1:  MANDATOS PARA BORRAR


       ** Escriba dw para borrar hasta el final de una palabra **


  1. Pulse <ESC> para asegurarse de que está en el modo Normal.

  2. Mueva el cursor a la línea de abajo señalada con --->.

  3. Mueva el cursor al comienzo de una palabra que desee borrar.

  4. Pulse   dw   para hacer que la palabra desaparezca.


  NOTA: Las letras   dw   aparecerán en la última línea de la pantalla cuando
	las escriba. Si escribe algo equivocado pulse <ESC> y comience de nuevo.


---> Hay algunas palabras pásalo bien que no pertenecen papel a esta frase.


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		    Lección 2.2: MÁS MANDATOS PARA BORRAR


	  ** Escriba  d$  para borrar hasta el final de la línea. **


  1. Pulse  <ESC>  para asegurarse de que está en el modo Normal.

  2. Mueva el cursor a la línea de abajo señalada con --->.

  3. Mueva el cursor al final de la línea correcta (DESPUÉS del primer . ).

  4. Escriba  d$  para borrar hasta el final de la línea.

---> Alguien ha escrito el final de esta línea dos veces. esta línea dos veces.







~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		    Lección 2.3: SOBRE MANDATOS Y OBJETOS


  El formato del mandato de borrar   d	 es como sigue:

	 [número]   d	objeto	    O	     d	 [número]   objeto
  donde:
   número - es cuántas veces se ha de ejecutar el mandato (opcional, defecto=1).
   d - es el mandato para borrar.
   objeto - es sobre lo que el mandato va a operar (lista, abajo).

  Una lista corta de objetos:
   w - desde el cursor hasta el final de la palabra, incluyendo el espacio.
   e - desde el cursor hasta el final de la palabra, SIN incluir el espacio.
   $ - desde el cursor hasta el final de la línea.

NOTE: Para los aventureros, pulsando sólo el objeto estando en modo Normal
      sin un mandato moverá el cursor como se especifica en la lista de objetos.



~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       Lección 2.4: UNA EXCEPCIÓN AL 'MANDATO-OBJETO'

	   ** Escriba	dd   para borrar una línea entera. **

  Debido a la frecuencia con que se borran líneas enteras, los diseñadores
  de Vim decidieron que sería más fácil el escribir simplemente dos des en
  una fila para borrar	una línea.

  1. Mueva el cursor a la segunda línea de la lista de abajo.
  2. Escriba  dd  para borrar la línea.
  3. Muévase ahora a la cuarta línea.
  4. Escriba   2dd   (recuerde	número-mandato-objeto) para borrar las dos
     líneas.

      1) Las rosas son rojas,
      2) El barro es divertido,
      3) El cielo es azul,
      4) Yo tengo un coche,
      5) Los relojes marcan la hora,
      6) El azucar es dulce,
      7) Y así eres tu.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		       Lección 2.5: EL MANDATO DESHACER


   ** Pulse  u	para deshacer los últimos mandatos,
	     U	para deshacer una línea entera.       **

  1. Mueva el cursor a la línea de abajo señalada con ---> y sitúelo bajo el
     primer error.
  2. Pulse  x  para borrar el primer caráter erróneo.
  3. Pulse ahora  u  para deshacer el último mandato ejecutado.
  4. Ahora corrija todos los errores de la línea usando el mandato  x.
  5. Pulse ahora  U  mayúscula para devolver la línea a su estado original.
  6. Pulse ahora  u  unas pocas veces para deshacer lo hecho por  U  y los
     mandatos previos.
  7. Ahora pulse CTRL-R (mantenga pulsada la tecla CTRL y pulse R) unas
     pocas veces para volver a ejecutar los mandatos (deshacer lo deshecho).

---> Corrrija los errores dee esttta línea y vuuelva a ponerlos coon deshacer.

  8. Estos mandatos son muy útiles. Ahora pase al resumen de la Lección 2.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			    RESUMEN DE LA LECCIÓN 2

  1. Para borrar desde el cursor hasta el final de una palabra pulse:	dw

  2. Para borrar desde el cursor hasta el final de una línea pulse:	d$

  3. Para borrar una línea entera pulse:    dd

  4. El formato de un mandato en modo Normal es:

       [número]   mandato   objeto   O	 mandato   [número]   objeto
     donde:
       número - es cuántas veces se ha de ejecutar el mandato
       mandato - es lo que hay que hacer, por ejemplo, d para borrar
       objeto - es sobre lo que el mandato va a operar, por ejemplo
		w (palabra), $ (hasta el final de la línea), etc.

  5. Para deshacer acciones previas pulse:		 u (u minúscula)
     Para deshacer todos los cambios de una línea pulse: U (U mayúscula)
     Para deshacer lo deshecho pulse:			 CTRL-R


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			 Lección 3.1: EL MANDATO «PUT» (poner)

  ** Pulse p para poner lo último que ha borrado después del cursor. **

  1. Mueva el cursor al final de la lista de abajo.

  2. Escriba  dd  para borrar la línea y almacenarla en el buffer de Vim.

  3. Mueva el cursor a la línea que debe quedar por debajo de la
     línea a mover.

  4. Estando en mod Normal, pulse   p	para restituir la línea borrada.

  5. Repita los pasos 2 a 4 para poner todas las líneas en el orden correcto.

     d) ¿Puedes aprenderla tu?
     b) Las violetas son azules,
     c) La inteligencia se aprende,
     a) Las rosas son rojas,

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		       Lección 3.2: EL MANDATO «REPLACE» (remplazar)


  ** Pulse  r  y un carácter para sustituir el carácter sobre el cursor. **


  1. Mueva el cursor a la primera línea de abajo señalada con --->.

  2. Mueva el cursor para situarlo bajo el primer error.

  3. Pulse   r	 y el carácter que debe sustituir al erróneo.

  4. Repita los pasos 2 y 3 hasta que la primera línea esté corregida.

---> ¡Cuendo esta línea fue rscrita alguien pulso algunas teclas equibocadas!
---> ¡Cuando esta línea fue escrita alguien pulsó algunas teclas equivocadas!






~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			Lección 3.3: EL MANDATO «CHANGE» (cambiar)


     ** Para cambiar parte de una palabra o toda ella escriba  cw . **


  1. Mueva el cursor a la primera línea de abajo señalada con --->.

  2. Sitúe el cursor en la u de lubrs.

  3. Escriba  cw  y corrija la palabra (en este caso, escriba 'ínea').

  4. Pulse <ESC> y mueva el cursor al error siguiente (el primer carácter
     que deba cambiarse).

  5. Repita los pasos 3 y 4 hasta que la primera frase sea igual a la segunda.

---> Esta lubrs tiene unas pocas pskavtad que corregir usem el mandato change.
---> Esta línea tiene unas pocas palabras que corregir usando el mandato change.


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		      Lección 3.4: MÁS CAMBIOS USANDO c

   ** El mandato change se utiliza con los mismos objetos que delete. **

  1. El mandato change funciona de la misma forma que delete. El formato es:

       [número]   c   objeto	   O	    c	[número]   objeto

  2. Los objetos son tambiém los mismos, tales como  w (palabra), $ (fin de
     la línea), etc.

  3. Mueva el cursor a la primera línea de abajo señalada con --->.

  4. Mueva el cursor al primer error.

  5. Escriba  c$  para hacer que el resto de la línea sea como la segunda
     y pulse <ESC>.

---> El final de esta línea necesita alguna ayuda para que sea como la segunda.
---> El final de esta línea necesita ser corregido usando el mandato  c$.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			    RESUMEN DE LA LECCIÓN 3


  1. Para sustituir texto que ha sido borrado, pulse  p . Esto Pone el texto
     borrado DESPUÉS del cursor (si lo que se ha borrado es una línea se
     situará sobre la línea que está sobre el cursor).

  2. Para sustituir el carácter bajo el cursor, pulse	r   y luego el
     carácter que sustituirá al original.

  3. El mandato change le permite cambiar el objeto especificado desde la
     posición del cursor hasta el final del objeto; e.g. Pulse	cw  para
     cambiar desde el cursor hasta el final de la palabra, c$  para cambiar
     hasta el final de la línea.

  4. El formato para change es:

	 [número]   c	objeto	      O		c   [número]   objeto

  Pase ahora a la lección siguiente.


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       Lección 4.1: SITUACIÓN EN EL FICHERO Y SU ESTADO


 ** Pulse CTRL-g para mostrar su situación en el fichero y su estado.
    Pulse MAYU-G para moverse a una determinada línea del fichero. **

  Nota: ¡¡Lea esta lección entera antes de ejecutar alguno de los pasos!!


  1. Mantenga pulsada la tecla Ctrl y pulse  g . Aparece una línea de estado
     al final de la pantalla con el nombre del fichero y la línea en la que
     está situado. Recuerde el número de la línea para el Paso 3.

  2. Pulse Mayu-G para ir al final del fichero.

  3. Escriba el número de la línea en la que estaba y despúes Mayu-G. Esto
     le volverá a la línea en la que estaba cuando pulsó Ctrl-g.
     (Cuando escriba los números NO se mostrarán en la pantalla).

  4. Si se siente confiado en poder hacer esto ejecute los pasos 1 a 3.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			Lección 4.2: EL MANDATO «SEARCH» (buscar)

     ** Escriba  /  seguido de una frase para buscar la frase. **

  1. En modo Normal pulse el carácter  / . Fíjese que tanto el carácter  /
     como el cursor aparecen en la última línea de la pantalla, lo mismo
     que el mandato  : .

  2. Escriba ahora   errroor   <INTRO>. Esta es la palabra que quiere buscar.

  3. Para repetir la búsqueda, simplemente pulse  n .
     Para busacar la misma frase en la dirección opuesta, pulse Mayu-N .

  4. Si quiere buscar una frase en la dirección opuesta (hacia arriba),
     utilice el mandato  ?  en lugar de  / .

---> Cuando la búsqueda alcanza el final del fichero continuará desde el
     principio.

  «errroor» no es la forma de deletrear error; errroor es un error.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       Lección 4.3: BÚSQUEDA PARA COMPROBAR PARÉNTESIS

   ** Pulse %  para encontrar el paréntesis correspondiente a ),] o } . **


  1. Sitúe el cursor en cualquiera de los caracteres ), ] o } en la línea de
     abajo señalada con --->.

  2. Pulse ahora el carácter  %  .

  3. El cursor debería situarse en el paréntesis (, corchete [ o llave {
     correspondiente.

  4. Pulse  %  para mover de nuevo el cursor al paréntesis, corchete o llave
     correspondiente.

---> Esto ( es una línea de prueba con (, [, ], {, y } en ella. )).

Nota: ¡Esto es muy útil en la detección de errores en un programa con
      paréntesis, corchetes o llaves disparejos.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		  Lección 4.4: UNA FORMA DE CAMBIAR ERRORES


    ** Escriba	:s/viejo/nuevo/g para sustituir 'viejo' por 'nuevo'. **


  1. Mueva el cursor a la línea de abajo señalada con --->.

  2. Escriba  :s/laas/las/  <INTRO> . Tenga en cuenta que este mandato cambia
     sólo la primera aparición en la línea de la expresión a cambiar.

---> Laas mejores épocas para ver laas flores son laas primaveras.

  4. Para cambiar todas las apariciones de una expresión ente dos líneas
     escriba   :#,#s/viejo/nuevo/g   donde #,# son los números de las dos
     líneas. Escriba   :%s/viejo/nuevo/g   para hacer los cambios en todo
     el fichero.





~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			    RESUMEN DE LA LECCIÓN 4


  1. Ctrl-g  muestra la posición del cursor en el fichero y su estado.
     Mayu-G mueve el cursor al final del fichero. Un número de línea
     seguido de Mayu-G mueve el cursor a la línea con ese número.

  2. Pulsando  /  seguido de una frase busca la frase hacia ADELANTE.
     Pulsando  ?  seguido de una frase busca la frase hacia ATRÁS.
     Después de una búsqueda pulse  n  para encontrar la aparición
     siguiente en la misma dirección.

  3. Pulsando  %  cuando el cursor esta sobre (,), [,], { o } localiza
     la pareja correspondiente.

  4. Para cambiar viejo por nuevo en una línea pulse	      :s/viejo/nuevo
     Para cambiar todos los viejo por nuevo en una línea pulse :s/viejo/nuevo/g
     Para cambiar frases entre dos números de líneas pulse  :#,#s/viejo/nuevo/g
     Para cambiar viejo por nuevo en todo el fichero pulse  :%s/viejo/nuevo/g
     Para pedir confirmación en cada caso añada  'c'	    :%s/viejo/nuevo/gc


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		Lección 5.1: CÓMO EJECUTAR UN MANDATO EXTERNO


  ** Escriba  :!  seguido de un mandato externo para ejecutar ese mandato. **


  1. Escriba el conocido mandato  :  para situar el cursor al final de la
     pantalla. Esto le permitirá introducir un mandato.

  2. Ahora escriba el carácter ! (signo de admiración). Esto le permitirá
     ejecutar cualquier mandato del sistema.

  3. Como ejemplo escriba   ls	 después del ! y luego pulse <INTRO>. Esto
     le mostrará una lista de su directorio, igual que si estuviera en el
     símbolo del sistema. Si  ls  no funciona utilice	!:dir	.

--->Nota: De esta manera es posible ejecutar cualquier mandato externo.

--->Nota: Todos los mandatos   :   deben finalizarse pulsando <INTRO>.


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		     Lección 5.2: MÁS SOBRE GUARDAR FICHEROS


     ** Para guardar los cambios hechos en un fichero,
	escriba  :w NOMBRE_DE_FICHERO. **


  1. Escriba  :!dir  o	:!ls  para ver una lista de su directorio.
     Ya sabe que debe pulsar <INTRO> después de ello.

  2. Elija un nombre de fichero que todavía no exista, como TEST.

  3. Ahora escriba   :w TEST  (donde TEST es el nombre de fichero elegido).

  4. Esta acción guarda todo el fichero  (Vim Tutor)  bajo el nombre TEST.
     Para comprobarlo escriba	:!dir	de nuevo y vea su directorio.

---> Tenga en cuenta que si sale de Vim y  entra de nuevo con el nombre de
     fichero TEST, el fichero sería una copia exacta del tutor cuando lo
     ha guardado.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	       Lección 5.3: UN MANDATO DE ESCRITURA SELECTIVO

   ** Para guardar parte del fichero escriba   :#,# NOMBRE_DEL_FICHERO **


  1. Escriba de nuevo, una vez más,  :!dir  o  :!ls  para obtener una lista
     de su directorio y elija nombre de fichero adecuado, como TEST.

  2. Mueva el cursor al principio de la pantalla y pulse  Ctrl-g  para saber
     el número de la línea correspondiente. ¡RECUERDE ESTE NÚMERO!

  3. Ahora mueva el cursor a la última línea de la pantalla y pulse Ctrl-g
     de nuevo. ¡RECUERDE TAMBIÉN ESTE NÚMERO!

  4. Para guardar SOLAMENTE una parte de un fichero, escriba  :#,# w TEST
     donde #,# son los números que usted ha recordado (primera línea,
     última línea) y TEST es su nombre de dichero.

  5. De nuevo, vea que el fichero esta ahí con	:!dir  pero NO lo borre.


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		Lección 5.4: RECUPERANDO Y MEZCLANDO FICHEROS

 ** Para insertar el contenido de un fichero escriba :r NOMBRE_DEL_FICHERO **

  1. Escriba   :!dir   para asegurarse de que su fichero TEST del ejercicio
     anterior está presente.

  2. Situe el cursor al principio de esta pantalla.

NOTA: Después de ejecutar el paso 3 se verá la Lección 5.3. Luego muévase
      hacia ABAJO para ver esta lección de nuevo.

  3. Ahora recupere el fichero TEST utilizando el mandato  :r TEST  donde
     TEST es el nombre del fichero.

NOTA: El fichero recuperado se sitúa a partir de la posición del cursor.

  4. Para verificar que el fichero ha sido recuperado, mueva el cursor hacia
     arriba y vea que hay dos copias de la Lección 5.3, la original y la
     versión del fichero.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			   RESUMEN DE LA LECCIÓN 5


  1.  :!mandato  ejecuta un mandato externo.

      Algunos ejemplos útiles son:
	  :!dir - muestra el contenido de un directorio.
	  :!del NOMBRE_DE_FICHERO  -  borra el fichero NOMBRE_DE FICHERO.

  2.  :#,#w NOMBRE_DE _FICHERO  guarda desde las líneas # hasta la # en el
     fichero NOMBRE_DE_FICHERO.

  3.  :r NOMBRE_DE _FICHERO  recupera el fichero del disco NOMBRE_DE FICHERO
     y lo inserta en el fichero en curso a partir de la posición del cursor.







~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			 Lección 6.1: EL MANDATO «OPEN» (abrir)


	 ** Pulse  o  para abrir una línea debajo del cursor
	    y situarle en modo Insert **


  1. Mueva el cursor a la línea de abajo señalada con --->.

  2. Pulse  o (minúscula) para abrir una línea por DEBAJO del cursor
     y situarle en modo Insert.

  3. Ahora copie la línea señalada con ---> y pulse <ESC> para salir del
     modo Insert.

---> Luego de pulsar  o  el cursor se sitúa en la línea abierta en modo Insert.

  4. Para abrir una línea por encima del cursor, simplemente pulse una O
     mayúscula, en lugar de una o minúscula. Pruebe este en la línea siguiente.
Abra una línea sobre ésta pulsando Mayu-O cuando el curso está en esta línea.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			Lección 6.2: EL MANDATO «APPEND» (añadir)

	 ** Pulse  a  para insertar texto DESPUÉS del cursor. **


  1. Mueva el cursor al final de la primera línea de abajo señalada con --->
     pulsando  $  en modo Normal.

  2. Escriba una  a  (minúscula) para añadir texto DESPUÉS del carácter
     que está sobre el cursor. (A mayúscula añade texto al final de la línea).

Nota: ¡Esto evita el pulsar  i , el último carácter, el texto a insertar,
      <ESC>, cursor a la derecha y, finalmente, x , sólo para añadir algo
      al final de una línea!

  3. Complete ahora la primera línea. Nótese que append es exactamente lo
     mismo que modo Insert, excepto por el lugar donde se inserta el texto.

---> Esta línea le permitirá praticar
---> Esta línea le permitirá praticar el añadido de texto al final de una línea.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		     Lección 6.3: OTRA VERSIÓN DE «REPLACE» (remplazar)

    ** Pulse una  R  mayúscula para sustituir más de un carácter. **


  1. Mueva el cursor a la primera línea de abajo señalada con --->.

  2. Sitúe el cursor al comienzo de la primera palabra que sea diferente
     de las de la segunda línea marcada con ---> (la palabra 'anterior').

  3. Ahora pulse  R  y sustituya el resto del texto de la primera línea
     escribiendo sobre el viejo texto para que la primera línea sea igual
     que la primera.

---> Para hacer que esta línea sea igual que la anterior use las teclas.
---> Para hacer que esta línea sea igual que la siguiente escriba R y el texto.

  4. Nótese que cuando pulse <ESC> para salir, el texto no alterado permanece.



~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			 Lección 6.4: FIJAR OPCIONES

 ** Fijar una opción de forma que una búsqueda o sustitución ignore la caja **
  (Para el concepto de caja de una letra, véase la nota al final del fichero)


  1. Busque 'ignorar' introduciendo:
     /ignorar
     Repita varias veces la búsque pulsando la tecla n

  2. Fije la opción 'ic' (Ignorar la caja de la letra) escribiendo:
     :set ic

  3. Ahora busque 'ignorar' de nuevo pulsando n
     Repita la búsqueda varias veces más pulsando la tecla n

  4. Fije las opciones 'hlsearch' y 'insearch':
     :set hls is

  5. Ahora introduzca la orden de búsqueda otra vez, y vea qué pasa:
     /ignore

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			   RESUMEN DE LA LECCIÓN 6


  1. Pulsando  o  abre una línea por DEBAJO del cursor y sitúa el cursor en
     la línea abierta en modo Insert.
     Pulsando una O mayúscula se abre una línea SOBRE la que está el cursor.

  2. Pulse una	a  para insertar texto DESPUÉS del carácter sobre el cursor.
     Pulsando una  A  mayúscula añade automáticamente texto al final de la
     línea.

  3. Pulsando una  R  mayúscula se entra en modo Replace hasta que, para salir,
     se pulse <ESC>.

  4. Escribiendo «:set xxx» fija la opción «xxx»







~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		  Lección 7: MANDATOS PARA LA AYUDA EN LÍNEA

		 ** Utilice el sistema de ayuda en línea **


  Vim dispone de un sistema de ayuda en línea. Para activarlo, pruebe una
  de estas tres formas:
	- pulse la tecla <AYUDA> (si dispone de ella)
	- pulse la tecla <F1> (si dispone de ella)
	- escriba   :help <INTRO>

  Escriba   :q <INTRO>	 para cerrar la ventana de ayuda.

  Puede encontrar ayuda en casi cualquier tema añadiendo un argumento al
  mandato «:help» mandato. Pruebe éstos:

  :help w <INTRO>
  :help c_<T <INTRO>
  :help insert-index <INTRO>


~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  Aquí concluye el tutor de Vim. Está pensado para dar una visión breve del
  editor Vim, lo suficiente para permitirle usar el editor de forma bastante
  sencilla. Está muy lejos de estar completo pues Vim tiene muchísimos más
  mandatos.

  Para lecturas y estudios posteriores se recomienda el libro:
	Learning the Vi Editor - por Linda Lamb
	Editorial: O'Reilly & Associates Inc.
  Es un buen libro para llegar a saber casi todo lo que desee hacer con Vi.
  La sexta edición incluye también información sobre Vim.

  Este tutorial ha sido escrito por Michael C. Pierce y Robert K. Ware,
  Colorado School of Mines utilizando ideas suministradas por Charles Smith,
  Colorado State University.
  E-mail: bware@mines.colorado.edu.

  Modificado para Vim por Bram Moolenaar.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  Traducido del inglés por:

  Eduardo F. Amatria
  Correo electrónico: eferna1@platea.pntic.mec.es

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
